/*	Renegade Scripts.dll
	Example Plugin Code
	Copyright 2007 Whitedragon(MDB), Jonathan Wilson

	This file is part of the Renegade scripts.dll
	The Renegade scripts.dll is free software; you can redistribute it and/or modify it under
	the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2, or (at your option) any later
	version. See the file COPYING for more details.
	In addition, an exemption is given to allow Run Time Dynamic Linking of this code with any closed source module that does not contain code covered by this licence.
	Only the source code to the module(s) containing the licenced code has to be released.
*/

/*  This is designed to serve as both an example on how to make a plugin and to give users the basic framework of a plugin.
    The plugin is simple: it creates an object creation hook and attaches the script "Plugin_Example_Script" to all objects.
	The script prints out a message whenever an object is created or destroyed.
	There are also examples of the new format for bhs.dll hooks.
*/

#include "scripts.h"
#include <stdarg.h>
#ifdef WIN32
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#endif
#include "engine.h"
#include "gmmain.h"
#include "plugin.h"
#include "float.h"

ExampleSettingsStruct *ExampleSettings = 0;

void ExampleSettingsStruct::Load() {
	SettingsLoader::Load();

	LoadBool(Var,"Variable");
	printf("ExampleSettings variable: %d\n",Var);

	LoadList(List,"List");
	printf("ExampleSettings List[0]: %s\n",List[0].c_str());
}

int ObjectHookID = 0;
ObjectCreateHookStruct *ObjectHookStruct = 0;


void ObjectHookCall(void *data,GameObject *obj) {
}

int C4Limit_Disarm(int Team, int Mode, long double Count) 
{
	long double Total = 0;
	for(GenericSLNode *x = BaseGameObjList->HeadNode; x != 0; x = x->NodeNext)
	{
		GameObject *o = As_C4GameObj(As_ScriptableGameObj((GameObject *)x->NodeData));
		if (o && Get_C4_Mode(o) == Mode && Get_Object_Type(o) == Team) 
		{
			Total++;
			if (Total == Count) 
			{
				Disarm_C4(o);
				break;
			}
 		}
	}
 	return Total;
}
 
void C4_Limit_Glue(int Team) 
{
	int Type = 0;
	for(GenericSLNode *x = BaseGameObjList->HeadNode; x != 0; x = x->NodeNext)
	{
		GameObject *o = As_C4GameObj(As_ScriptableGameObj((GameObject *)x->NodeData));
		if (o && Get_Object_Type(o) == Team) {
			if (Get_C4_Mode(o) != 2)
			{
				Type = Get_C4_Mode(o);				
				break;
			} 
			else 
			{
				break;
			}
		}
	}
	if (Type == 0) return;
 
	long double CurrentMines = 0;
	if (Type == 1) CurrentMines = Get_C4_Count_Remote_Custom(Team);
	else CurrentMines = Get_C4_Count_Proximity_Custom(Team);
 
	if (CurrentMines > Get_Mine_Limit()) 
	{
		C4Limit_Disarm(Team, Type, CurrentMines);
	}
}

Hook *C4Limit = new Hook;

void Plugin_Load() {
	ExampleSettings = new ExampleSettingsStruct("Example.ini");

	ObjectHookStruct = new ObjectCreateHookStruct;
	ObjectHookStruct->hook = ObjectHookCall;
	ObjectHookStruct->data = 0;
	ObjectHookID = AddObjectCreateHook(ObjectHookStruct);

	C4Limit->Install('\xE8', 0x0070AD79, (int)&C4_Limit_Glue, ""); // TEST
}

void Plugin_Unload() {
	delete ExampleSettings;
	delete ObjectHookStruct;
}



bool Hooking::ReadMemory(int Address, void* Buffer, int Size)
{
	bool ret = 1;
	DWORD OldProtect;
	HANDLE Process = OpenProcess(PROCESS_ALL_ACCESS, false, GetCurrentProcessId());
	VirtualProtectEx(Process, (LPVOID)Address, Size, PAGE_EXECUTE_READWRITE, &OldProtect);
	if (!ReadProcessMemory(Process, (LPVOID)Address, Buffer, Size, NULL))
	{
		ret = 0;
	}
	VirtualProtectEx(Process, (LPVOID)Address, Size, OldProtect, NULL);
	CloseHandle(Process);
	return ret;
}
 
bool Hooking::WriteMemory(int Address, const void* Buffer, int Size)
{
	bool ret = 1;
	DWORD OldProtect;
	HANDLE Process = OpenProcess(PROCESS_ALL_ACCESS, false, GetCurrentProcessId());
	VirtualProtectEx(Process, (LPVOID)Address, Size, PAGE_EXECUTE_READWRITE, &OldProtect);
	if (!WriteProcessMemory(Process, (LPVOID)Address, Buffer, Size, NULL))
	{
		ret = 0;
	}
	VirtualProtectEx(Process, (LPVOID)Address, Size, OldProtect, NULL);
	CloseHandle(Process);
	return ret;
}


extern "C" {

DLLEXPORT void SSGM_Chat_Hook(int ID, int Type, const wchar_t *Msg) {
}

DLLEXPORT void SSGM_Host_Hook(int ID, int Type, const char *Msg) {
}

DLLEXPORT void SSGM_Player_Join_Hook(int ID, const char *Nick) {
}

DLLEXPORT void SSGM_Player_Leave_Hook(int ID) {
}

DLLEXPORT void SSGM_Level_Loaded_Hook() {
}

DLLEXPORT void SSGM_GameOver_Hook() {
}

DLLEXPORT void SSGM_Console_Output_Hook(const char *Output) {
}
}


